#include<iostream>
#include "ezwin.h"
#include "bitmap.h"
#include "circle.h"
#include "rect.h"
using namespace std;

SimpleWindow MainMenu("Main Menu",26,16);   //mainmenu window
SimpleWindow PauseMenu("Pause Menu",26,16);   //game pause window
SimpleWindow OptionMenu("Options",26,16);       //options window
SimpleWindow QuitMenu("Quit Menu",18,13);    //quit window
SimpleWindow GameStartPic("Gamestart",26,16);

int MainMenuClickEvent(const Position &);
int OptionMenuClickEvent(const Position &);
int QuitMenuClickEvent(const Position &);
int PauseMenuClickEvent(const Position &);

BitMap Mainmenuwindow(MainMenu);
BitMap Playgame_tab(MainMenu);
BitMap Options_tab(MainMenu);
BitMap Quit_tab(MainMenu);
BitMap Gamepausemenuwindow(PauseMenu);
BitMap Resume_tab(PauseMenu);
BitMap Restart_tab(PauseMenu);
BitMap Backtomainmenu_tab(PauseMenu);
BitMap Quitmenuwindow(QuitMenu);
BitMap Quit_yes_tab(QuitMenu);
BitMap Quit_no_tab(QuitMenu);
BitMap Optionsmenuwindow(OptionMenu);
BitMap Instructions_tab(OptionMenu);
BitMap Credits_tab(OptionMenu);
BitMap Backto_Mainmenu_tab(OptionMenu);
BitMap Initialwindow(GameStartPic);

float position_tab=0;
void optionmenu();
void mainmenu();
void quitmenu();
void gamestart();

void PicturesLoad(void)
{
Mainmenuwindow.Load("Pictures/mainmenu.xpm");
Playgame_tab.Load("Pictures/playgame.xpm");
Options_tab.Load("Pictures/options.xpm");
Quit_tab.Load("Pictures/quit.xpm");
Optionsmenuwindow.Load("Pictures/optionmenu.xpm");
Instructions_tab.Load("Pictures/instructions.xpm");
Credits_tab.Load("Pictures/credits.xpm");
Backto_Mainmenu_tab.Load("Pictures/mainmenutab.xpm");
Quitmenuwindow.Load("Pictures/quitwindow.xpm");
Quit_yes_tab.Load("Pictures/yes.xpm");
Quit_no_tab.Load("Pictures/no.xpm");
Backtomainmenu_tab.Load("Pictures/mainmenutab.xpm");
Restart_tab.Load("Pictures/restart.xpm");
Resume_tab.Load("Pictures/resume.xpm");
Gamepausemenuwindow.Load("Pictures/gamepause.xpm");
}

int ApiMain()
{
	GameStartPic.Open();
	Initialwindow.Load("Pictures/start1.xpm");
	Initialwindow.SetPosition(Position(6.5,2));
	Initialwindow.Draw();
	PicturesLoad();
	GameStartPic.Close();
	
	MainMenu.Open();
	Mainmenuwindow.SetPosition(Position(position_tab+5.5,position_tab+2));
	Mainmenuwindow.Draw();
	
	Playgame_tab.SetPosition(Position(position_tab+6.5,position_tab+5));
	Playgame_tab.Draw();

	Options_tab.SetPosition(Position(position_tab+10.75,position_tab+7));
	Options_tab.Draw();

	Quit_tab.SetPosition(Position(position_tab+15,position_tab+9));
	Quit_tab.Draw();
	MainMenu.SetMouseClickCallback(MainMenuClickEvent);
	return 0;
}

int MainMenuClickEvent(const Position &p)
{

	if(Playgame_tab.IsInside(p))
        {
		MainMenu.Close();
		//play();
		cout<<"play";
	}
	if(Options_tab.IsInside(p))	
	{
	        MainMenu.Close();
	 	OptionMenu.Open();
		
		Optionsmenuwindow.SetPosition(Position(5.5,2));
		Optionsmenuwindow.Draw();
			
		Instructions_tab.SetPosition(Position(6.5,5));
		Instructions_tab.Draw();
		
		Credits_tab.SetPosition(Position(10.75,7));
		Credits_tab.Draw();
		
		Backto_Mainmenu_tab.SetPosition(Position(15,9));
		Backto_Mainmenu_tab.Draw();
		OptionMenu.SetMouseClickCallback(OptionMenuClickEvent); 
	}
	if(Quit_tab.IsInside(p))	
	{
	        MainMenu.Close();
	 	QuitMenu.Open();
		
		Quitmenuwindow.SetPosition(Position(3.5,4));
		Quitmenuwindow.Draw();
			
		Quit_yes_tab.SetPosition(Position(6.6,5.7));
		Quit_yes_tab.Draw();
		
		Quit_no_tab.SetPosition(Position(6.6,7.5));
		Quit_no_tab.Draw();
		QuitMenu.SetMouseClickCallback(QuitMenuClickEvent); 
	}	
}

int OptionMenuClickEvent(const Position &v)
{
	if(Instructions_tab.IsInside(v))
	{
	 	//	instructions();
		cout<<"instructions";
	}
	if(Credits_tab.IsInside(v))
	{
		//	credits();
		cout<<"credits";
	}
	if(Backto_Mainmenu_tab.IsInside(v))
	{
		//	mainmenu();
        }
}

int QuitMenuClickEvent(const Position &y)
{
	if(Quit_yes_tab.IsInside(y))
	{
		//	exit();
		cout<<"exit";
	}
	if(Quit_no_tab.IsInside(y))
	{
	//	mainmenu();
		cout<<"no";
        }
}


void pausemenu()
{
	PauseMenu.Open();
	
	Gamepausemenuwindow.SetPosition(Position(position_tab+5.5,position_tab+2));
	Gamepausemenuwindow.Draw();
	
	Resume_tab.SetPosition(Position(position_tab+6.5,position_tab+5));
	Resume_tab.Draw();
	
	Restart_tab.SetPosition(Position(position_tab+10.75,position_tab+7));
	Restart_tab.Draw();
	
	Backtomainmenu_tab.SetPosition(Position(position_tab+15,position_tab+9));
	Backtomainmenu_tab.Draw();
	PauseMenu.SetMouseClickCallback(PauseMenuClickEvent);
}

int PauseMenuClickEvent(const Position &z)
{
	if(Resume_tab.IsInside(z))
        {
		PauseMenu.Close();
		//resume();
		cout<<"resume";
	}
	if(Restart_tab.IsInside(z))	
	{
	        PauseMenu.Close();
	 	//restart();
		cout<<"restart";
	}
	if(Backtomainmenu_tab.IsInside(z))	
	{
	        PauseMenu.Close();
	 	//mainmenu();
		cout<<"mainmenu";
        }
}
